/*
 * Decompiled with CFR 0.152.
 */
package jclass.table3;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Hashtable;
import jclass.cell.CellData;
import jclass.cell.CellEditor;
import jclass.cell.CellRenderer;
import jclass.cell.renderers.StringCellRenderer;
import jclass.table3.DrawRange;
import jclass.table3.EditableTableData;
import jclass.table3.JCCellRange;
import jclass.table3.Table;
import jclass.table3.TableData;
import jclass.table3.TableDataEvent;
import jclass.table3.TableDataListener;
import jclass.table3.TableDataUtil;
import jclass.table3.TableException;
import jclass.table3.TraverseInitial;
import jclass.table3.VarSize;
import jclass.util.JCString;

public class TableDataView
implements TableDataListener,
Serializable {
    Table parent;
    TableData dataSource;
    boolean isEditable = false;
    transient Hashtable renderers;
    transient Hashtable editors;
    private int[] swappedColumns;
    private int[] swappedRows;
    boolean needs_swapped_columns = false;
    boolean needs_swapped_rows = false;
    private boolean containsJCStringURL = false;
    JCCellRange cellRange = new JCCellRange();

    private TableDataView() {
        this(null);
    }

    public TableDataView(Table table) {
        this.parent = table;
        this.InitEditorRenderers();
    }

    public void InitEditorRenderers() {
        this.InitEditorHashtable();
        this.InitRendererHashtable();
    }

    public void dataChanged(TableDataEvent tableDataEvent) {
        int n;
        int n2 = tableDataEvent.getRow();
        if (n2 >= 0) {
            n2 = this.getViewRow(n2);
        }
        if ((n = tableDataEvent.getColumn()) >= 0) {
            n = this.getViewColumn(n);
        }
        switch (tableDataEvent.getCommand()) {
            case 1: {
                if (this.parent.editHandler.getCellEditor() != null && n2 == this.parent.edit_row && n == this.parent.edit_column) {
                    this.parent.editHandler.cancel();
                }
                int n3 = this.parent.getPixelWidth(n);
                int n4 = this.parent.getPixelHeight(n2);
                int n5 = 65536;
                if (n3 == 33001 || n4 == 33001) {
                    this.parent.setProperty(n5 |= VarSize.calc(this.parent, n2, n, n3, n4), n2, n);
                }
                this.repaintTable(n2, n);
                return;
            }
            case 2: {
                if (this.parent.editHandler.getCellEditor() != null && n2 == this.parent.edit_row) {
                    this.parent.editHandler.cancel();
                }
                this.repaintTable(n2, -1, n2, this.dataSource.getNumColumns());
                return;
            }
            case 3: {
                if (this.parent.editHandler.getCellEditor() != null) {
                    this.parent.editHandler.cancel();
                }
                TableDataUtil.addRow(this.parent, n2, 1, this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                this.repaintTable(n2, -1, this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                return;
            }
            case 4: {
                if (this.parent.editHandler.getCellEditor() != null) {
                    this.parent.editHandler.cancel();
                }
                if (this.needs_swapped_rows) {
                    int n6 = 0;
                    while (n6 < tableDataEvent.getNumAffected()) {
                        int n7 = this.getViewRow(tableDataEvent.getRow() + n6);
                        this.swappedRows = this.removeSwappedElement(this.swappedRows, n7);
                        TableDataUtil.deleteRow(this.parent, n7, 1, this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                        ++n6;
                    }
                    this.repaintTable();
                    return;
                }
                TableDataUtil.deleteRow(this.parent, tableDataEvent.getRow(), tableDataEvent.getNumAffected(), this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                if (this.dataSource.getNumRows() > 0) {
                    this.repaintTable(tableDataEvent.getRow(), -1, this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                    return;
                }
                this.repaintTable();
                return;
            }
            case 5: {
                if (this.parent.editHandler.getCellEditor() != null && n == this.parent.edit_column) {
                    this.parent.editHandler.cancel();
                }
                this.repaintTable(-1, n, this.dataSource.getNumRows(), n);
                return;
            }
            case 6: {
                if (this.parent.editHandler.getCellEditor() != null) {
                    this.parent.editHandler.cancel();
                }
                TableDataUtil.addColumn(this.parent, tableDataEvent.getColumn(), 1, this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                this.repaintTable(-1, tableDataEvent.getColumn(), this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                return;
            }
            case 7: {
                if (this.parent.editHandler.getCellEditor() != null) {
                    this.parent.editHandler.cancel();
                }
                if (this.needs_swapped_columns) {
                    int n8 = 0;
                    while (n8 < tableDataEvent.getNumAffected()) {
                        int n9 = this.getViewColumn(tableDataEvent.getColumn() + n8);
                        this.swappedColumns = this.removeSwappedElement(this.swappedColumns, n9);
                        TableDataUtil.deleteColumns(this.parent, n9, 1, this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                        ++n8;
                    }
                    this.repaintTable();
                    return;
                }
                TableDataUtil.deleteColumns(this.parent, tableDataEvent.getColumn(), tableDataEvent.getNumAffected(), this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                if (this.dataSource.getNumColumns() > 0) {
                    this.repaintTable(-1, tableDataEvent.getColumn(), this.dataSource.getNumRows(), this.dataSource.getNumColumns());
                    return;
                }
                this.repaintTable();
                return;
            }
            case 8: {
                int n10 = this.parent.getPixelWidth(-1);
                int n11 = this.parent.getPixelHeight(n2);
                int n12 = 65536;
                if (n10 == 33001 || n11 == 33001) {
                    this.parent.setProperty(n12 |= VarSize.calc(this.parent, n2, -1, n10, n11), n2, -1);
                }
                this.repaintTable(n2, -1);
                return;
            }
            case 9: {
                int n13 = this.parent.getPixelWidth(n);
                int n14 = this.parent.getPixelHeight(-1);
                int n15 = 65536;
                if (n13 == 33001 || n14 == 33001) {
                    this.parent.setProperty(n15 |= VarSize.calc(this.parent, -1, n, n13, n14), -1, n);
                }
                this.repaintTable(-1, n);
                return;
            }
            case 10: {
                if (this.parent.editHandler.getCellEditor() != null) {
                    this.parent.editHandler.cancel();
                }
                TableDataUtil.moveRows(this.parent, tableDataEvent.getRow(), tableDataEvent.getNumAffected(), tableDataEvent.getDestination());
                this.repaintTable();
                return;
            }
            case 11: {
                if (this.parent.editHandler.getCellEditor() != null) {
                    this.parent.editHandler.cancel();
                }
                TableDataUtil.moveColumns(this.parent, tableDataEvent.getColumn(), tableDataEvent.getNumAffected(), tableDataEvent.getDestination());
                this.repaintTable();
                return;
            }
            case 12: {
                int n16 = this.dataSource.getNumRows();
                if (this.parent.edit_row >= n16) {
                    this.parent.edit_column = -999;
                    this.parent.edit_row = -999;
                }
                if (this.parent.rows != n16) {
                    if (this.parent.editHandler.getCellEditor() != null && n16 <= this.parent.edit_row) {
                        this.parent.editHandler.cancel();
                    }
                    this.parent.rows = n16;
                    this.parent.setProperty(1408);
                }
                this.resetSwappedRows();
                return;
            }
            case 13: {
                int n17 = this.dataSource.getNumColumns();
                if (this.parent.edit_column >= n17) {
                    this.parent.edit_column = -999;
                    this.parent.edit_row = -999;
                }
                if (this.parent.columns != n17) {
                    if (this.parent.editHandler.getCellEditor() != null && n17 <= this.parent.edit_row) {
                        this.parent.editHandler.cancel();
                    }
                    this.parent.columns = n17;
                    this.parent.setProperty(146);
                }
                this.resetSwappedColumns();
                return;
            }
            case 14: {
                int n18 = this.dataSource.getNumRows();
                int n19 = this.dataSource.getNumColumns();
                if (this.parent.edit_row >= n18 || this.parent.edit_column >= n19) {
                    this.parent.edit_column = -999;
                    this.parent.edit_row = -999;
                }
                if (this.parent.rows != n18) {
                    if (this.parent.editHandler.getCellEditor() != null && n18 <= this.parent.edit_row) {
                        this.parent.editHandler.cancel();
                    }
                    this.parent.rows = n18;
                    this.parent.setProperty(1408);
                }
                this.resizeSwappedRows();
                if (this.parent.columns != n19) {
                    if (this.parent.editHandler.getCellEditor() != null && n19 <= this.parent.edit_row) {
                        this.parent.editHandler.cancel();
                    }
                    this.parent.columns = n19;
                    this.parent.setProperty(146);
                }
                this.resizeSwappedColumns();
                this.repaintTable();
                return;
            }
        }
    }

    public void setDataSource(TableData tableData) {
        boolean bl = false;
        if (tableData == null) {
            return;
        }
        this.parent.setRepaint(false);
        if (this.dataSource != null) {
            bl = true;
            this.dataSource.removeTableDataListener(this);
            bl = true;
            this.parent.cancelEdit(true);
        }
        this.dataSource = tableData;
        this.dataSource.addTableDataListener(this);
        this.isEditable = this.dataSource instanceof EditableTableData;
        this.parent.rows = this.dataSource.getNumRows();
        this.parent.columns = this.dataSource.getNumColumns();
        this.resetSwappedRows();
        this.resetSwappedColumns();
        this.containsJCStringURL = false;
        this.parent.needs_recalc = true;
        this.parent.setProperty(786624);
        if (bl) {
            this.parent.edit_column = -999;
            this.parent.edit_row = -999;
            this.parent.setTopRow(0);
            this.parent.setLeftColumn(0);
        }
        this.parent.setRepaint(true);
        if (bl) {
            TraverseInitial.traverse(this.parent, false);
        }
    }

    public TableData getDataSource() {
        return this.dataSource;
    }

    public boolean getEditable() {
        return this.isEditable;
    }

    public Object getCellData(int n, int n2) {
        if (this.dataSource == null) {
            return null;
        }
        if (!this.parent.trackJCStringURL || this.containsJCStringURL) {
            return this.dataSource.getTableDataItem(this.getDataRow(n), this.getDataColumn(n2));
        }
        Object object = this.dataSource.getTableDataItem(this.getDataRow(n), this.getDataColumn(n2));
        Object object2 = object;
        if (object2 instanceof CellData) {
            object2 = ((CellData)object).getData();
        }
        if (object2 instanceof JCString) {
            this.containsJCStringURL = this.containsURL((JCString)object2);
        }
        return object;
    }

    private boolean containsURL(JCString jCString) {
        if (jCString == null || jCString.size() == 0) {
            return false;
        }
        int n = 0;
        int n2 = jCString.size();
        while (n < n2) {
            if (jCString.elementAt(n) == JCString.HREF) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean setCellData(Object object, int n, int n2) {
        int n3 = this.getDataColumn(n2);
        int n4 = this.getDataRow(n);
        if (this.isEditable) {
            return ((EditableTableData)this.dataSource).setTableDataItem(object, n4, n3);
        }
        return true;
    }

    public Object getColumnLabel(int n) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableColumnLabel(this.getDataColumn(n));
    }

    public Object getRowLabel(int n) {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getTableRowLabel(this.getDataRow(n));
    }

    public int getNumRows() {
        return this.dataSource.getNumRows();
    }

    public int getNumColumns() {
        return this.dataSource.getNumColumns();
    }

    private void repaintTable() {
        this.parent.repaint();
    }

    private void repaintTable(int n, int n2) {
        DrawRange.draw(this.parent, this.cellRange.reshape(n, n2));
    }

    private void repaintTable(int n, int n2, int n3, int n4) {
        DrawRange.draw(this.parent, this.cellRange.reshape(n, n2, n3, n4));
    }

    public int[] getSwappedColumns() {
        int n = this.dataSource.getNumColumns();
        if (this.swappedColumns == null || this.swappedColumns.length < n) {
            this.resizeSwappedColumns();
        }
        return this.swappedColumns;
    }

    public int[] getSwappedRows() {
        int n = this.dataSource.getNumRows();
        if (this.swappedRows == null || this.swappedRows.length < n) {
            this.resizeSwappedRows();
        }
        return this.swappedRows;
    }

    public int getDataColumn(int n) {
        if (this.swappedColumns == null) {
            return n;
        }
        int n2 = this.dataSource.getNumColumns();
        if (this.swappedColumns == null || this.swappedColumns.length < n2) {
            this.resizeSwappedColumns();
        }
        if (n < n2) {
            return this.swappedColumns[n];
        }
        return -999;
    }

    public Object getData(int n, int n2) {
        if (n >= 0 && n2 >= 0) {
            return this.getCellData(n, n2);
        }
        if (n == -1) {
            return this.getColumnLabel(n2);
        }
        return this.getRowLabel(n);
    }

    public int getDataRow(int n) {
        if (this.swappedRows == null) {
            return n;
        }
        int n2 = this.dataSource.getNumRows();
        if (this.swappedRows == null || this.swappedRows.length < n2) {
            this.resizeSwappedRows();
        }
        if (n < n2) {
            return this.swappedRows[n];
        }
        return -999;
    }

    public int getViewColumn(int n) {
        if (this.swappedColumns == null) {
            return n;
        }
        int n2 = this.dataSource.getNumColumns();
        if (this.swappedColumns == null || this.swappedColumns.length < n2) {
            this.resizeSwappedColumns();
        }
        if (n < n2) {
            if (this.swappedColumns[n] == n) {
                return n;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (this.swappedColumns[n3] == n) {
                    return n3;
                }
                ++n3;
            }
        }
        return -999;
    }

    public int getViewRow(int n) {
        if (this.swappedRows == null) {
            return n;
        }
        int n2 = this.dataSource.getNumRows();
        if (this.swappedRows == null || this.swappedRows.length < n2) {
            this.resizeSwappedRows();
        }
        if (n < n2) {
            if (this.swappedRows[n] == n) {
                return n;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (this.swappedRows[n3] == n) {
                    return n3;
                }
                ++n3;
            }
        }
        return -999;
    }

    protected void resizeSwappedColumns() {
        if (!this.needs_swapped_columns) {
            return;
        }
        int n = this.dataSource.getNumColumns();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.swappedColumns == null || n2 >= this.swappedColumns.length ? n2 : this.swappedColumns[n2];
            ++n2;
        }
        this.swappedColumns = nArray;
    }

    protected void resizeSwappedRows() {
        if (!this.needs_swapped_rows) {
            return;
        }
        int n = this.dataSource.getNumRows();
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = this.swappedRows == null || n2 >= this.swappedRows.length ? n2 : this.swappedRows[n2];
            ++n2;
        }
        this.swappedRows = nArray;
    }

    protected void resetSwappedColumns() {
        this.needs_swapped_columns = false;
        if (this.swappedColumns != null) {
            int n = this.swappedColumns.length;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            this.setSwappedColumns(nArray);
        }
        this.swappedColumns = null;
        this.repaintTable();
    }

    protected void resetSwappedRows() {
        this.needs_swapped_rows = false;
        if (this.swappedRows != null) {
            int n = this.swappedRows.length;
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = n2;
                ++n2;
            }
            this.setSwappedRows(nArray);
        }
        this.swappedRows = null;
        this.repaintTable();
    }

    protected boolean dragColumn(int n, int n2) {
        int n3 = this.dataSource.getNumColumns();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        this.needs_swapped_columns = true;
        if (this.swappedColumns == null || this.swappedColumns.length < n3) {
            this.resizeSwappedColumns();
        }
        this.swappedColumns = this.shiftSwappedArray(this.swappedColumns, n, n2);
        boolean bl = TableDataUtil.dragColumn(this.parent, n, n2);
        this.repaintTable();
        return bl;
    }

    protected boolean dragRow(int n, int n2) {
        int n3 = this.dataSource.getNumRows();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        this.needs_swapped_rows = true;
        if (this.swappedRows == null || this.swappedRows.length < n3) {
            this.resizeSwappedRows();
        }
        this.swappedRows = this.shiftSwappedArray(this.swappedRows, n, n2);
        boolean bl = TableDataUtil.dragRow(this.parent, n, n2);
        this.repaintTable();
        return bl;
    }

    protected int[] shiftSwappedArray(int[] nArray, int n, int n2) {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        if (n2 == Integer.MAX_VALUE) {
            int n4 = 0;
            while (n4 < n) {
                nArray2[n4] = nArray[n4];
                ++n4;
            }
            int n5 = n + 1;
            while (n5 < n3) {
                nArray2[n5 - 1] = nArray[n5];
                ++n5;
            }
            nArray2[n3 - 1] = nArray[n];
        } else if (n < n2) {
            int n6 = 0;
            while (n6 < n3) {
                nArray2[n6] = nArray[n6];
                ++n6;
            }
            int n7 = n + 1;
            while (n7 < n2) {
                nArray2[n7 - 1] = nArray[n7];
                ++n7;
            }
            nArray2[n2 - 1] = nArray[n];
        } else if (n > n2) {
            int n8 = 0;
            while (n8 < n3) {
                nArray2[n8] = nArray[n8];
                ++n8;
            }
            int n9 = n2;
            while (n9 < n) {
                nArray2[n9 + 1] = nArray[n9];
                ++n9;
            }
            nArray2[n2] = nArray[n];
        }
        return nArray2;
    }

    protected int[] removeSwappedElement(int[] nArray, int n) {
        if (nArray == null) {
            return null;
        }
        int n2 = nArray.length;
        int[] nArray2 = new int[n2 - 1];
        int n3 = 0;
        while (n3 < n2) {
            if (n3 < n) {
                nArray2[n3] = nArray[n3];
            } else if (n3 > n) {
                nArray2[n3 - 1] = nArray[n3];
            }
            ++n3;
        }
        return nArray2;
    }

    protected boolean swapColumns(int n, int n2) {
        int n3 = this.dataSource.getNumColumns();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0 || n2 > n3) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        if (this.parent.editHandler.getCellEditor() != null) {
            this.parent.editHandler.cancel();
        }
        this.needs_swapped_columns = true;
        if (this.swappedColumns == null || this.swappedColumns.length < n3) {
            this.resizeSwappedColumns();
        }
        int n4 = this.swappedColumns[n];
        this.swappedColumns[n] = this.swappedColumns[n2];
        this.swappedColumns[n2] = n4;
        TableDataUtil.swapColumns(this.parent, n, n2);
        this.repaintTable();
        return true;
    }

    public boolean setSwappedColumns(int[] nArray) {
        int n = this.dataSource.getNumColumns();
        if (nArray.length != n) {
            return false;
        }
        if (this.parent.editHandler.getCellEditor() != null) {
            this.parent.editHandler.cancel();
        }
        boolean bl = this.parent.getRepaint();
        this.parent.setRepaint(false);
        this.needs_swapped_columns = true;
        if (this.swappedColumns == null || this.swappedColumns.length < n) {
            this.resizeSwappedColumns();
        }
        if (TableDataUtil.swapColumnArrays(this.parent, this.swappedColumns, nArray)) {
            this.swappedColumns = nArray;
        }
        this.parent.setRepaint(bl);
        this.repaintTable();
        return true;
    }

    protected boolean swapRows(int n, int n2) {
        int n3 = this.dataSource.getNumRows();
        if (n < 0 || n > n3) {
            return false;
        }
        if (n2 < 0 || n2 > n3) {
            return false;
        }
        if (n == n2) {
            return true;
        }
        if (this.parent.editHandler.getCellEditor() != null) {
            this.parent.editHandler.cancel();
        }
        this.needs_swapped_rows = true;
        if (this.swappedRows == null || this.swappedRows.length < n3) {
            this.resizeSwappedRows();
        }
        int n4 = this.swappedRows[n];
        this.swappedRows[n] = this.swappedRows[n2];
        this.swappedRows[n2] = n4;
        TableDataUtil.swapRows(this.parent, n, n2);
        this.repaintTable();
        return true;
    }

    public boolean setSwappedRows(int[] nArray) {
        int n = this.dataSource.getNumRows();
        if (nArray.length != n) {
            return false;
        }
        if (this.parent.editHandler.getCellEditor() != null) {
            this.parent.editHandler.cancel();
        }
        this.needs_swapped_rows = true;
        if (this.swappedRows != null && this.swappedRows.length > n) {
            this.resetSwappedRows();
        }
        if (this.swappedRows == null || this.swappedRows.length < n) {
            this.resizeSwappedRows();
        }
        if (this.parent.sort_series) {
            if (TableDataUtil.swapRowArrays(this.parent, this.swappedRows, nArray)) {
                this.swappedRows = nArray;
                this.repaintTable();
            }
        } else {
            this.swappedRows = nArray;
            this.repaintTable();
        }
        return true;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.InitRendererHashtable();
        this.InitEditorHashtable();
    }

    protected boolean trackJCStringURL() {
        return this.parent.track_cursor && this.containsJCStringURL;
    }

    private void InitRendererHashtable() {
        this.renderers = new Hashtable();
        try {
            this.renderers.put(Class.forName("java.awt.Image"), Class.forName("jclass.cell.renderers.ImageCellRenderer"));
            this.renderers.put(Class.forName("jclass.util.JCString"), Class.forName("jclass.table3.JCStringCellRenderer"));
            this.renderers.put(Class.forName("java.lang.String"), Class.forName("jclass.cell.renderers.StringCellRenderer"));
            this.renderers.put(Class.forName("java.lang.Object"), Class.forName("jclass.cell.renderers.StringCellRenderer"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.parent != null && this.parent.advanced_editor_renderers) {
            this.loadFieldRenderers(this.renderers);
        }
    }

    public CellRenderer getCellRenderer(int n, int n2) {
        Object object = n != -1 && n2 != -1 ? this.getCellData(n, n2) : (n == -1 ? this.getColumnLabel(n2) : this.getRowLabel(n));
        return this.getCellRenderer(n, n2, object);
    }

    public CellRenderer getCellRenderer(int n, int n2, Object object) {
        CellRenderer cellRenderer = null;
        if (object instanceof CellData && (cellRenderer = ((CellData)object).getRenderer()) != null) {
            return cellRenderer;
        }
        cellRenderer = this.parent.getCellRenderer(n, n2);
        if (cellRenderer == null) {
            return this.getCellRenderer(object);
        }
        return cellRenderer;
    }

    public Hashtable getRenderersTable() {
        return this.renderers;
    }

    public void setRenderersTable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        try {
            if (hashtable.get(Class.forName("java.lang.Object")) == null) {
                hashtable.put(Class.forName("java.lang.Object"), Class.forName("jclass.cell.renderers.StringCellRenderer"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TableException("No renderer for java.lang.Object available");
        }
        this.renderers = hashtable;
    }

    public CellRenderer getCellRenderer(Object object) {
        if (object == null) {
            return new StringCellRenderer();
        }
        CellRenderer cellRenderer = null;
        try {
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = null;
            Object var5_6 = null;
            do {
                var5_6 = this.renderers.get(clazz);
                clazz2 = clazz;
                clazz = clazz.getSuperclass();
            } while (var5_6 == null);
            if (var5_6 instanceof Class) {
                cellRenderer = (CellRenderer)((Class)var5_6).newInstance();
                this.renderers.put(clazz2, cellRenderer);
            } else {
                cellRenderer = var5_6;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (cellRenderer == null) {
            throw new TableException("No renderer for " + object.getClass().getName() + " available");
        }
        return cellRenderer;
    }

    private void InitEditorHashtable() {
        this.editors = new Hashtable();
        try {
            this.editors.put(Class.forName("java.lang.Boolean"), Class.forName("jclass.cell.editors.BooleanCellEditor"));
            this.editors.put(Class.forName("java.util.Date"), Class.forName("jclass.cell.editors.DateCellEditor"));
            this.editors.put(Class.forName("java.lang.Double"), Class.forName("jclass.cell.editors.DoubleCellEditor"));
            this.editors.put(Class.forName("java.lang.Float"), Class.forName("jclass.cell.editors.FloatCellEditor"));
            this.editors.put(Class.forName("java.lang.Integer"), Class.forName("jclass.cell.editors.IntegerCellEditor"));
            this.editors.put(Class.forName("jclass.util.JCString"), Class.forName("jclass.table3.JCStringCellEditor"));
            this.editors.put(Class.forName("java.lang.String"), Class.forName("jclass.table3.TextCellEditor"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.parent != null && this.parent.advanced_editor_renderers) {
            this.loadFieldEditors(this.editors);
        }
    }

    public CellEditor getCellEditor(int n, int n2) {
        Object object = n != -1 && n2 != -1 ? this.getCellData(n, n2) : (n == -1 ? this.getColumnLabel(n2) : this.getRowLabel(n));
        CellEditor cellEditor = null;
        if (object instanceof CellData) {
            return ((CellData)object).getEditor();
        }
        cellEditor = this.parent.getCellEditor(n, n2);
        if (cellEditor == null) {
            return this.getCellEditor(object);
        }
        return cellEditor;
    }

    public Hashtable getEditorsTable() {
        return this.editors;
    }

    public void setEditorsTable(Hashtable hashtable) {
        if (hashtable == null) {
            return;
        }
        this.editors = hashtable;
    }

    public CellEditor getCellEditor(Object object) {
        if (object == null) {
            return null;
        }
        if (this.editors.size() == 0) {
            return null;
        }
        CellEditor cellEditor = null;
        try {
            Class<?> clazz = object.getClass();
            Class<?> clazz2 = null;
            Object var5_6 = null;
            do {
                var5_6 = this.editors.get(clazz);
                clazz2 = clazz;
                clazz = clazz.getSuperclass();
            } while (var5_6 == null && clazz != null);
            if (var5_6 instanceof Class) {
                cellEditor = (CellEditor)((Class)var5_6).newInstance();
                this.editors.put(clazz2, cellEditor);
            } else {
                cellEditor = var5_6;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return cellEditor;
    }

    void dispose() {
        if (this.dataSource != null) {
            this.dataSource.removeTableDataListener(this);
            this.dataSource = null;
        }
        if (this.parent != null) {
            this.parent = null;
        }
    }

    protected void loadFieldRenderers(Hashtable hashtable) {
        try {
            hashtable.put(Class.forName("java.lang.Float"), Class.forName("jclass.field.cell.DoubleRendererEditor"));
            hashtable.put(Class.forName("java.lang.Double"), Class.forName("jclass.field.cell.DoubleRendererEditor"));
            hashtable.put(Class.forName("java.lang.Integer"), Class.forName("jclass.field.cell.IntegerRendererEditor"));
            hashtable.put(Class.forName("java.lang.Long"), Class.forName("jclass.field.cell.IntegerRendererEditor"));
            hashtable.put(Class.forName("java.lang.Byte"), Class.forName("jclass.field.cell.IntegerRendererEditor"));
            hashtable.put(Class.forName("java.lang.Long"), Class.forName("jclass.field.cell.IntegerRendererEditor"));
            hashtable.put(Class.forName("java.util.Date"), Class.forName("jclass.field.cell.DateRendererEditor"));
            hashtable.put(Class.forName("java.util.Calendar"), Class.forName("jclass.field.cell.DateRendererEditor"));
            hashtable.put(Class.forName("java.sql.Date"), Class.forName("jclass.field.cell.DateRendererEditor"));
            hashtable.put(Class.forName("java.sql.Timestamp"), Class.forName("jclass.field.cell.DateRendererEditor"));
            hashtable.put(Class.forName("java.sql.Time"), Class.forName("jclass.field.cell.DateRendererEditor"));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return;
        }
    }

    protected void loadFieldEditors(Hashtable hashtable) {
        this.loadFieldRenderers(hashtable);
    }
}

